
## Настройки

Загрузчик тесно связан с протоколом передачи и основывается на фреймах UEBA_ FRAME (0xbabf) 
Каждый пакет данных зашифрован AES128 CBC, IV = 0; IV сбрасывается при записи новой страницы. 
Ключ шифрования устанавливается новый для каждого нового типа устройства, на данный момент они такие:

|   |   |   |
|---|---|---|
|Название устройства|Ключ шифрования|Описание|
| AR | 8F-1A-12-81-C6-9E-07-9F-9A-06-B8-2E-F7-94-5F-49 | Antena-rotate |


Каждое устройство по-своему вводится в режим программирования. Детальнее как ввести устройство в режим программирования сказано в README к устройству. 
Так как для перевода в данные режим используется основная программа устройства (либо ее отсутствие, либо наличие джампера при включении) то адресация в данном режиме отсутствует. 

## Формат передачи данных

|   |   |   |
|---|---|---|
|UEBA_FRAME (0xbabf)|SPM_PAGESIZE + 16 зашифрованных байтов данных|2 байта crc|

Формат зашифрованных данных:

|   |   |   |   |   |
|---|---|---|---|---|
|2 байта CRC блока|2 байта сигнатура устройства|4 байта адрес записи|8 байт – 0|SPM_PAGESIZE байта данных. <br><br>Страница памяти|

Количество байт зависит от процессора. И именуется SPM_PAGESIZE
По CRC и сигнатуре устройства определяется правильность пароля и целостность блока в целом Если блок неправильный, то устройство вернет NACK_FRAME (0xbac2)
Второй раз CRC считается за расшифрованный блок – 2 первых байта CRC
Если блок был записан, то будет выведено ACK_FRAME (0xbac1)

Контрольная сумма как для зашифрованной части, так и в целом считается как CRC-X25 (0x8408-0xffff ^ 0xffff) без включения контрольной суммы в расчет, и без управляющих последовательностей (т.е 512+16)

  
# Формат файла прошивки
  
Прошивка представляет из себя xml файл. Файл должен иметь вид `[DEV].R[DATE].uebf`

Формат:
```xml
<root>
<fw>
    <version>[Номер версии прошивки]</version>
    <date>[Дата сборки]</date>
    <branch>[Ветка GIT]</branch>
    <commit>[Номер комита]</commit>
    <device>[Внутренее название устройства]</device>
</fw>
<chunks>
    <chunk>[BASE64 данные прошивки]</chunk>
…
    <chunk>[BASE64 данные прошивки]</chunk>
</chunks>
</root>

Где chunk – зашифрованные куски прошивки по SPM_PAGESIZE+16+2+2 байт. Т.е все данные которые будут отправлены в порт.
```
